unit SafeMem;

interface
Procedure SafeGetMem(var P; Size: {$IFDEF Win32}Integer{$ELSE}Word{$ENDIF});
Procedure SafeFreeMem(var P; Size: {$IFDEF Win32}Integer{$ELSE}Word{$ENDIF});

implementation
{$IFDEF DEBUGMSG}
Uses
  STConfig, kUnits;
{$ENDIF}

Procedure SafeGetMem(var P; Size: {$IFDEF Win32}Integer{$ELSE}Word{$ENDIF});
begin
  GetMem(Pointer(P), Size);
  if Pointer(P)<>nil Then FillChar(Pointer(P)^, Size, 0);
end;

Procedure SafeFreeMem(var P; Size: {$IFDEF Win32}Integer{$ELSE}Word{$ENDIF});
begin
  If Pointer(P)<>nil Then Begin FreeMem(Pointer(P), Size); Pointer(P):=nil End
  Else {$IFDEF DEBUGMSG}
    WriteToLog(DebugDetailed, kuSafeMem, 'SafeFreeMem', 'Releasing non NIL pointer'); {$ENDIF};
end;

end.
