{ 
    SemTel version 1.0.0 ... comfortable telnet client
    Copyright (C) 1995-2000 Jan Tomasek <jan@tomasek.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit NetworkPrinterInDirectModeSelect;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, xForms;

type
  TfNetworkPrinterInDirectModeSelect = class(TxForm)
    Panel1: TPanel;
    pnButtons: TPanel;
    PortList: TListBox;
    btnOk: TButton;
    btnCancel: TButton;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    PrinterName: String;
    { Public declarations }
  end;

var
  fNetworkPrinterInDirectModeSelect: TfNetworkPrinterInDirectModeSelect;

implementation
Uses
  STConfig, kUnits, WinSpool;

{$R *.DFM}
procedure TfNetworkPrinterInDirectModeSelect.FormShow(Sender: TObject);
Type
  TPrinterInfo1Array = Array[0..100000] of TPrinterInfo1;
  TPortInfo2Array = Array[0..100000] of TPortInfo2;
Var
  Needed            : Integer;
  Allocated         : Integer;
  Returned          : Integer;
  I, J              : Integer;
  Domains           :^TPrinterInfo1Array;
  DomainsCnt        : Integer;
  PrintServers      :^TPrinterInfo1Array;
  PrintServersCnt   : Integer;
begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuNetworkPrinterInDirectModeSelect, 'TfNetworkPrinterInDirectModeSelect.Create', 'Begin');{$ENDIF}
  Cursor:=crHourGlass;

  PortList.Items.Clear;

  // Scan for remote printers
  Needed:=0;
  EnumPrinters(PRINTER_ENUM_REMOTE, nil, 1, nil, 0, Needed, Returned);
  GetMem(Domains, Needed); Allocated:=Needed;
  EnumPrinters(PRINTER_ENUM_REMOTE, nil, 1, Domains, Allocated, Needed, DomainsCnt);
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfNetworkPrinterInDirectModeSelect.Create', Format('Domains count=%d', [DomainsCnt]));{$ENDIF}
  for I:=0 to DomainsCnt-1 do begin
    {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfNetworkPrinterInDirectModeSelect.Create', Format('Domain=%s(%x)', [Domains[i].pName, Domains[i].Flags]));{$ENDIF}
    if ((PRINTER_ENUM_CONTAINER and Domains[i].Flags)=PRINTER_ENUM_CONTAINER) then begin
      EnumPrinters(PRINTER_ENUM_NAME, Domains[i].pName, 1, nil, 0, Needed, Returned);
      GetMem(PrintServers, Needed); Allocated:=Needed;
      EnumPrinters(PRINTER_ENUM_NAME, Domains[i].pName, 1, PrintServers, Allocated, Needed, PrintServersCnt);
      for J:=0 to PrintServersCnt-1 do begin
        PortList.Items.Add(PrintServers[j].pName);
        PortList.Update;
        {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuConnPar, 'TfNetworkPrinterInDirectModeSelect.Create', Format('Print server=%s(%x)', [PrintServers[j].pName, PrintServers[j].Flags]));{$ENDIF}
      end;
      System.FreeMem(PrintServers);
    end;
  end;
  FreeMem(Domains);
  I:=StringsFindNearest(PortList.Items, PrinterName, False);
  if I>0 then PortList.Selected[I]:=True;

  Cursor:=crArrow;
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuNetworkPrinterInDirectModeSelect, 'TfNetworkPrinterInDirectModeSelect.Create', 'End');{$ENDIF}
end;

procedure TfNetworkPrinterInDirectModeSelect.FormClose(Sender: TObject; var Action: TCloseAction);
Var
  i: integer;
begin
  for i:=0 to PortList.Items.Count-1 do begin
    if PortList.Selected[i] then begin
      PrinterName:=PortList.Items[i];
    end;
  end;
end;

initialization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuNetworkPrinterInDirectModeSelect, 'initialization', '');{$ENDIF}
{$IFDEF Win32}finalization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuNetworkPrinterInDirectModeSelect, 'finalization', '');{$ENDIF}{$ENDIF}
end.
