{ 
    SemTel version 1.0.0 ... comfortable telnet client
    Copyright (C) 1995-2000 Jan Tomasek <jan@tomasek.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
{-------------------------------------------------------------------------------
Version  : 0.81.00
Date     : 01.05.1998
Dialog   : OTP calculator
History  : 01.05.1998 QC
-------------------------------------------------------------------------------}

unit OTPCalc;

interface

uses
  WinTypes, WinProcs, Forms,    Classes,
  Controls, StdCtrls, RXSplit,  ExtCtrls,
  INIFiles, xForms;

type
  TOnCount = procedure (Sender: TObject; Count: Integer) of Object;
  TfOTPCalc = class(TxForm)
    LChallenge  : TLabel;
    Challenge   : TEdit;
    LPassword   : TLabel;
    Password    : TEdit;
    Response    : TEdit;
    LResponse   : TLabel;
    DeletePass  : TCheckBox;
    bvSpliter   : TBevel;
    ButtonPanel : TPanel;
    btnOk       : TButton;
    btnCount    : TButton;
    btnCancel   : TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure btnCountClick(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
    FOnCount          :TOnCount;
    FOTPResponseValid :Boolean;
    Function ReadMSG:Boolean; override;
    Function ROTPChalenge:String;
    Procedure WOTPChalenge(S:String);
    Function ROTPResponse:String;
    Procedure WOTPResponse(S:String);
    Function RDeletePass:Boolean;
    Procedure WDeletePass(B:Boolean);

    Procedure Count;
  public
    { Public declarations }
    property OTPChallenge:String read ROTPChalenge write WOTPChalenge;
    property OTPResponseValid:Boolean read FOTPResponseValid write FOTPResponseValid;
    property OTPResponse:String read ROTPResponse write WOTPResponse;
    property DeletePassword:Boolean read RDeletePass write WDeletePass;
    property OnCount: TOnCount read FOnCount write FOnCount;
    Constructor Create(aOwner:TComponent); override;
    Destructor Destroy; override;
  end;

Var
  fOTPCalc  : TfOTPCalc;

implementation
{$R *.DFM}
Uses
  OTP, STConfig, kUnits;
Const
  ctOTPError : String = 'Chyba pi vpotu OTP. Chybn zadan vzva?';

Function TfOTPCalc.ReadMSG:Boolean;
Begin
  Result := Inherited ReadMSG;
  If Result Then Begin
    btnOk.Caption     := ctbtnOk;
    btnCancel.Caption := ctbtnCancel;
    ctOTPError        := ReadMSGString('OTPError');
  End;
End;

Function TfOTPCalc.ROTPChalenge:String;
Begin
  Result:=Challenge.Text;
End;

Procedure TfOTPCalc.WOTPChalenge(S:String);
Begin
  While S[1]=' ' Do System.Delete(S,1,1);
  While S[Length(S)]=' ' Do System.Delete(S,Length(S),1);
  Challenge.Text:=S;
End;

Function TfOTPCalc.ROTPResponse:String;
Begin
  Result:=Response.Text;
End;

Procedure TfOTPCalc.WOTPResponse(S:String);
Begin
  While S[1]=' ' Do System.Delete(S,1,1);
  While S[Length(S)]=' ' Do System.Delete(S,Length(S),1);
  Response.Text:=S;
End;

procedure TfOTPCalc.FormClose(Sender: TObject; var Action: TCloseAction);
Var
  I : Integer;
  S : String;
begin
  If DeletePass.Checked Then
   Begin
     S:=Password.Text;
     If Length(S)>0 Then
      For I:=1 To Length(S) Do S[I]:=#$FF;
     Password.Text:=S;
     Password.Text:='';
   End;
end;

procedure TfOTPCalc.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  If (Shift=[]) and (Key=VK_ESCAPE) Then Close;
end;

Constructor TfOTPCalc.Create(aOwner:TComponent);
Begin
  Inherited Create(aOwner);
  SavePosition      := True;
  FOTPResponseValid := False;
  ReadINI;
End;

Destructor TfOTPCalc.Destroy;
Begin
  WriteINI;

  Inherited Destroy;
End;

procedure TfOTPCalc.btnCountClick(Sender: TObject);
begin
  Count;
end;

Procedure TfOTPCalc.Count;
Var
  S   : String;
  Cnt : Integer;
begin
  If OTP.OTPResponse(Challenge.Text, Password.Text, S, Cnt) Then Begin
    If Assigned(FOnCount) Then Begin
      {$IFDEF WIN32}
      SetForegroundWindow(Handle);
      {$ELSE}
      WinProcs.SetFocus(Handle);
      {$ENDIF} 
      FOnCount(Self, Cnt);
    End;
    If Cnt<=0 Then Begin ModalResult:=mrCancel; Exit End;
    Response.Text:=S;
  End Else
    MessageBox(Handle,@ctOTPError[1],@ctError[1], MB_ICONSTOP or MB_OK);
end;

procedure TfOTPCalc.btnOkClick(Sender: TObject);
begin
  Count;
end;

procedure TfOTPCalc.FormShow(Sender: TObject);
begin
  If Length(Challenge.Text)>0 Then
   Begin
     ActiveControl:=Password;
     Password.SelectAll;
   End;
end;

Function TfOTPCalc.RDeletePass:Boolean;
Begin
  Result:=DeletePass.Checked;
End;

Procedure TfOTPCalc.WDeletePass(B:Boolean);
Begin
  DeletePass.Checked:=B;
End;

initialization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuOTPCalc, 'initialization', '');{$ENDIF}
{$IFDEF Win32}finalization
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuOTPCalc, 'finalization', '');{$ENDIF}{$ENDIF}
end.
