{ 
    SemTel version 1.0.0 ... comfortable telnet client
    Copyright (C) 1995-2000 Jan Tomasek <jan@tomasek.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit SafeMem;

interface
Procedure SafeGetMem(var P; Size: {$IFDEF Win32}Integer{$ELSE}Word{$ENDIF});
Procedure SafeFreeMem(var P; Size: {$IFDEF Win32}Integer{$ELSE}Word{$ENDIF});

implementation
{$IFDEF DEBUGMSG}
Uses
  STConfig, kUnits;
{$ENDIF}

Procedure SafeGetMem(var P; Size: {$IFDEF Win32}Integer{$ELSE}Word{$ENDIF});
begin
  GetMem(Pointer(P), Size);
  if Pointer(P)<>nil Then FillChar(Pointer(P)^, Size, 0);
end;

Procedure SafeFreeMem(var P; Size: {$IFDEF Win32}Integer{$ELSE}Word{$ENDIF});
begin
  If Pointer(P)<>nil Then Begin FreeMem(Pointer(P), Size); Pointer(P):=nil End
  Else {$IFDEF DEBUGMSG}
    WriteToLog(DebugDetailed, kuSafeMem, 'SafeFreeMem', 'Releasing non NIL pointer'); {$ENDIF};
end;

end.
