{ 
    SemTel version 1.0.0 ... comfortable telnet client
    Copyright (C) 1995-2000 Jan Tomasek <jan@tomasek.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit xForms;

interface
Uses
  Classes,  Forms,   INIFiles, C3216,
  Messages, WinTypes;

Type
  PINIFile =^TINIFile;
  TxForm = class (TForm)
    private
      FSavePosition : Boolean;
      FSaveSize     : Boolean;
      FSaveStatus   : Boolean;
    private
      procedure WMSGFile(MSG:PINIFile);
      procedure WINIFile(INI:PINIFile);
      function  RName:String;
    public
      { Public declarations }
      FMSGFile      : PINIFile;
      FINIFile      : PINIFile;
      Constructor Create(aOwner:TComponent); override;
      Destructor Destroy; override;
      Function  WriteINI:Boolean; virtual;
      Function  ReadINI:Boolean; virtual;
      Function  ReadMSG:Boolean; virtual;
      Function  ReadMSGString(Const Key: String):String;
      property MSGFile      : PINIFile Read FMSGFile       Write WMSGFile;
      property INIFile      : PINIFile Read FINIFile       Write WINIFile;
    protected
    published
      property iName        : String   Read RName;
      property SavePosition : Boolean  Read FSavePosition  Write FSavePosition;
      property SaveSize     : Boolean  Read FSaveSize      Write FSaveSize;
      property SaveStatus   : Boolean  Read FSaveStatus    Write FSaveStatus;
  End;

implementation
Uses
  Menus,    Dialogs,  StdCtrls, ExtCtrls,
  SysUtils, STConfig, kUnits;

Constructor TxForm.Create;
Const
  MethodName='TxForm.Create';
Begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuxForms, MethodName, 'Begin; class='+ClassName);{$ENDIF}

  Inherited Create(aOwner);
  FSavePosition := False;
  FSaveSize     := False;
  FSaveStatus   := False;
  ReadMSG;

  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuxForms, MethodName, 'End; class='+ClassName);{$ENDIF}
End;

Destructor TxForm.Destroy;
Const
  MethodName='TxForm.Destroy';
Begin
  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuxForms, MethodName, 'Begin; class='+ClassName);{$ENDIF}

  FMSGFile  := nil;
  FINIFile  := nil;
  Inherited Destroy;

  {$IFDEF DEBUGMSG}WriteToLog(DebugDetailed, kuxForms, MethodName, 'End; class='+ClassName);{$ENDIF}
End;

Function TxForm.WriteINI:Boolean;
Begin
  Result:=False;
  If Assigned(FINIFile) Then if CanBeRewriten(FINIFile.FileName) then Begin
    FINIFile^.EraseSection(iName);
    FINIFile^.WriteBool(iName,'SavePosition',SavePosition);
    FINIFile^.WriteBool(iName,'SaveSize',SaveSize);
    FINIFile^.WriteBool(iName,'SaveStatus',SaveStatus);
    If SavePosition Then
     Begin
       FINIFile^.WriteInteger(iName,'Position.Left',Left);
       FINIFile^.WriteInteger(iName,'Position.Top',Top);
     End;
    If SaveSize Then
     Begin
       FINIFile^.WriteInteger(iName,'Size.Width',Width);
       FINIFile^.WriteInteger(iName,'Size.Height',Height);
     End;
    If SaveStatus Then
     Begin
       FINIFile^.WriteBool(iName,'Status.Visible',Visible);
     End;
    Result:=True;
  End;
End;

Function TxForm.ReadINI:Boolean;
Begin
  Result:=False;

  If Assigned(FINIFile) Then Begin
    If SaveSize Then
     Begin
       Width :=FINIFile^.ReadInteger(iName,'Size.Width',Width);
       Height:=FINIFile^.ReadInteger(iName,'Size.Height',Height);
     End;
    If SavePosition Then
     Begin
       Left:=FINIFile^.ReadInteger(iName,'Position.Left',(Screen.Width-Width)div 2);
       Top :=FINIFile^.ReadInteger(iName,'Position.Top',(Screen.Height-Height)div 2);
     End;
    If SaveStatus Then
     Begin
       Visible:=INIFile^.ReadBool(iName,'Status.Visible',Visible);
     End;
    SavePosition := FINIFile^.ReadBool(iName,'SavePosition',SavePosition);
    SaveSize     := FINIFile^.ReadBool(iName,'SaveSize',SaveSize);
    SaveStatus   := FINIFile^.ReadBool(iName,'SaveStatus',SaveStatus);
    Result:=True;
  End;
End;

Function TxForm.ReadMSG:Boolean;
Var
  I,_To : Word;
  C     : TComponent;

Begin
  Result:=False;
  If Assigned(FMSGFile) Then Begin
    Begin
      _To := ComponentCount-1;
      If _To>=0 Then
        For I:=0 To _To Do
         Begin
           C:=Components[I];
           If C.Tag and 1 = 0 Then Continue; {Nebyl nasaven pozadavek na natahovani narodniho retezce}

           If C.ClassType=TLabel       Then Begin TLabel      (C).Caption:=ReadMSGString(C.Name);Continue End;
           If C.ClassType=TCheckBox    Then Begin TCheckBox   (C).Caption:=ReadMSGString(C.Name);Continue End;
           If C.ClassType=TRadioButton Then Begin TRadioButton(C).Caption:=ReadMSGString(C.Name);Continue End;
           If C.ClassType=TButton      Then Begin TButton     (C).Caption:=ReadMSGString(C.Name);Continue End;
           If C.ClassType=TMenuItem    Then Begin TMenuItem   (C).Caption:=ReadMSGString(C.Name);Continue End;
           If C.ClassType=TGroupBox    Then Begin TGroupBox   (C).Caption:=ReadMSGString(C.Name);Continue End;
           If C.ClassType=TPanel       Then Begin TPanel      (C).Caption:=ReadMSGString(C.Name);Continue End;
           If C.ClassType=TOpenDialog  Then Begin TOpenDialog (C).Title  :=ReadMSGString(C.Name);Continue End;
           If C.ClassType=TForm        Then Begin TForm       (C).Caption:=ReadMSGString(C.Name);Continue End;
         End;
      If Self.Tag and 1 = 1 Then Self.Caption:=ReadMSGString(Self.Name);
      Result:=True;
    End;
  End
End;

Function  TxForm.ReadMSGString(Const Key: String):String;
Begin
  If Assigned(FMSGFile) Then
    Result := FMSGFile^.ReadString(iName, Key, 'Error reading string')
  Else
    Result := '';
End;{ -- ReadMSGString --------------------------------------------------------}

procedure TxForm.WMSGFile(MSG:PINIFile);
Begin
  FMSGFile := MSG;
  ReadMSG;
End;

procedure TxForm.WINIFile(INI:PINIFile);
Begin
  FINIFile := INI;
  ReadINI;
End;

function  TxForm.RName:String;
Begin
  Result:=System.Copy(ClassName,2,Length(ClassName));
End;


End.
