{ 
    SemTel version 1.0.0 ... comfortable telnet client
    Copyright (C) 1995-2000 Jan Tomasek <jan@tomasek.cz>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit xTree;

interface
Uses
  Classes;
Type
  TPTV = Char; {TParserTreeValue}
{  PParserTreeElement =^TParserTreeElement;}
  TParserTreeElement = class(TObject)
    private
      FNodes   : TList;
      FAllNodes: TList;
      FValue   : Char;
      FSeq     : String;
      FCommand : Word;
      Function RSelfPtr:Pointer;
      Function NewNode(aCommand:Word;aValue:Char;Seq:String):TParserTreeElement;
    public
      Constructor Create(aCommand:Word;aValue:Char;Seq:String;AllNodes:TList); virtual;
      Destructor Destroy; override;
      Function  AddNode(aCommand:Word;aValue:Char;Seq:String):TParserTreeElement;
      Function GetNode(aValue:Char):TParserTreeElement;
      property Value: Char read FValue;
      property Command: Word read FCommand;
      property SelfPtr: Pointer read RSelfPtr;
      property Nodes:TList read FNodes;
      property Seq:String read FSeq;
  End;

  TParserTree = class(TPersistent)
    private
      FAllNodes : TList;
      FRoot     : TParserTreeElement;
    public
      Constructor Create; virtual;
      Destructor Destroy; override;
      procedure Add(CommandID:Word;CommandStr:String);
      property Root: TParserTreeElement read FRoot;
  End;


implementation
Uses
  Forms, WinProcs, WinTypes;
{-- TParserTreeElement ------------------------------------}
Function TParserTreeElement.NewNode(aCommand:Word;aValue:Char;Seq:String):TParserTreeElement;
Var
  X : TParserTreeElement;
Begin
  X := TParserTreeElement.Create(aCommand,aValue,Seq,FAllNodes);
  FAllNodes.Add(X);
  FNodes.Add(X);
  Result:=X;
End;

Function TParserTreeElement.RSelfPtr:Pointer;
Begin
  Result:=Self;
End;

Constructor TParserTreeElement.Create(aCommand:Word;aValue:Char;Seq:String;AllNodes:TList);
Begin
  FNodes     := TList.Create;
  FAllNodes  := AllNodes;
  FCommand   := aCommand;
  FValue     := aValue;
  If FCommand<>0 Then FSeq:=Seq;
End;

Destructor TParserTreeElement.Destroy;
Begin
  If FNodes<>nil Then FNodes.Clear;
  FNodes.Free;
  Inherited Destroy;
End;

Function TParserTreeElement.AddNode(aCommand:Word;aValue:Char;Seq:String):TParserTreeElement;
Begin
  If FNodes.Count=0 Then
   Begin
     Result:=NewNode(aCommand,aValue,Seq)
   End
  Else
   Begin
     Result:=GetNode(aValue);
     If Result=nil Then Result:=NewNode(aCommand,aValue,Seq);
   End;
End;

Function TParserTreeElement.GetNode(aValue:Char):TParserTreeElement;
Function IsEqual(XValue,aValue : Char):Boolean;
{//Const
//  Num = ['0','1','2','3','4','5','6','7','8','9'];}
Begin
  Result:=False;
  If XValue=aValue Then
   Result:=True        {
  Else
    If (XValue='')and(aValue in Num) Then Result:=True;}
End;
Var
  I : Word;
  X : TParserTreeElement;
Begin
  Result:=Nil;
  For I:=0 To FNodes.Count-1 Do
   Begin
     X:=FNodes.Items[I];
     If IsEqual(X.Value,aValue) Then
      Begin
        Result:=X;
        Exit;
      End;
   End;
End;

{-- TParserTree  ------------------------------------------}

Constructor TParserTree.Create;
Begin
  FAllNodes := TList.Create;
  FRoot     := TParserTreeElement.Create(0,#27,'',FAllNodes);
End;

Destructor TParserTree.Destroy;
Var
  I : Integer;
  P : TParserTreeElement;
Begin
  FRoot.Free; FRoot:=nil;
  For I:=0 To FAllNodes.Count-1 Do Begin
    P:=FAllNodes.Items[I];
    P.Free;
  End;
  FAllNodes.Clear; FAllNodes.Free; FAllNodes:=nil;
  inherited Destroy;
End;

procedure TParserTree.Add(CommandID:Word;CommandStr:String);
Var
  Element     : TParserTreeElement;
  Element_Nad : TParserTreeElement;
  Element_Nad1: TParserTreeElement;
  Element_Odd : TParserTreeElement;
  I       : Word;
  C       : Word;
  PomStr  : String;
Begin
  Element:=FRoot;
  PomStr :='';
  For I:=1 To Length(CommandStr) Do
   Begin
     If I=Length(CommandStr) Then C:=CommandID Else C:=0;
     PomStr:=PomStr+Element.Value;
     If CommandStr[I]='' Then
      Begin
        {Element      = , nejake cislo}
        {Element_Nad  = , nejake cislo, nasledujici za Element}
        {Element_Nad1 = , nejake cislo, nasledujici za Element_Nad}
        {Element_Odd  = znak identifikujici pozadovanou akci}
        Element     := Element.AddNode(C,CommandStr[I],CommandStr);
        Element_Nad := Element.AddNode(C,CommandStr[I],CommandStr);
        Element_Nad1:= Element.AddNode(C,CommandStr[I],CommandStr);
        If (I+1)=Length(CommandStr) Then C:=CommandID Else C:=0;
        Element_Odd := Element.AddNode(C,CommandStr[I+1],CommandStr);
        Element_Nad.Nodes.Add(Element_Odd);
        Element_Nad.Nodes.Add(Element_Nad1);
        Element_Nad1.Nodes.Add(Element_Odd);
      End
     Else
      Element:=Element.AddNode(C,CommandStr[I],CommandStr);
   End;
   PomStr:=PomStr+Element.Value;
End;

end.
